Public Class Form1
  Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub
  Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
  Friend WithEvents MenuItem1 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem3 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem7 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuRandomize As System.Windows.Forms.MenuItem
  Friend WithEvents MenuBubble As System.Windows.Forms.MenuItem
  Friend WithEvents MenuSelection As System.Windows.Forms.MenuItem
  Friend WithEvents menuQuick As System.Windows.Forms.MenuItem
  Friend WithEvents MenuExit As System.Windows.Forms.MenuItem
  Friend WithEvents CheckBoxAscending As System.Windows.Forms.CheckBox
  Friend WithEvents CheckBoxShowSwaps As System.Windows.Forms.CheckBox

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.Container

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.MenuBubble = New System.Windows.Forms.MenuItem()
    Me.MenuItem7 = New System.Windows.Forms.MenuItem()
    Me.CheckBoxAscending = New System.Windows.Forms.CheckBox()
    Me.MenuItem1 = New System.Windows.Forms.MenuItem()
    Me.MenuExit = New System.Windows.Forms.MenuItem()
    Me.MenuSelection = New System.Windows.Forms.MenuItem()
    Me.MenuItem3 = New System.Windows.Forms.MenuItem()
    Me.MenuRandomize = New System.Windows.Forms.MenuItem()
    Me.menuQuick = New System.Windows.Forms.MenuItem()
    Me.CheckBoxShowSwaps = New System.Windows.Forms.CheckBox()
    Me.MainMenu1 = New System.Windows.Forms.MainMenu()
    Me.SuspendLayout()
    '
    'MenuBubble
    '
    Me.MenuBubble.Index = 2
    Me.MenuBubble.Shortcut = System.Windows.Forms.Shortcut.F2
    Me.MenuBubble.Text = "Bubble"
    '
    'MenuItem7
    '
    Me.MenuItem7.Index = 1
    Me.MenuItem7.Text = "-"
    '
    'CheckBoxAscending
    '
    Me.CheckBoxAscending.Checked = True
    Me.CheckBoxAscending.CheckState = System.Windows.Forms.CheckState.Checked
    Me.CheckBoxAscending.Location = New System.Drawing.Point(592, 440)
    Me.CheckBoxAscending.Name = "CheckBoxAscending"
    Me.CheckBoxAscending.Size = New System.Drawing.Size(112, 24)
    Me.CheckBoxAscending.TabIndex = 0
    Me.CheckBoxAscending.Text = "Ascending"
    '
    'MenuItem1
    '
    Me.MenuItem1.Index = 0
    Me.MenuItem1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuExit})
    Me.MenuItem1.Text = "&File"
    '
    'MenuExit
    '
    Me.MenuExit.Index = 0
    Me.MenuExit.Text = "E&xit"
    '
    'MenuSelection
    '
    Me.MenuSelection.Index = 3
    Me.MenuSelection.Shortcut = System.Windows.Forms.Shortcut.F3
    Me.MenuSelection.Text = "Selection"
    '
    'MenuItem3
    '
    Me.MenuItem3.Index = 1
    Me.MenuItem3.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuRandomize, Me.MenuItem7, Me.MenuBubble, Me.MenuSelection, Me.menuQuick})
    Me.MenuItem3.Text = "&Sort"
    '
    'MenuRandomize
    '
    Me.MenuRandomize.Index = 0
    Me.MenuRandomize.Text = "Randomize"
    '
    'menuQuick
    '
    Me.menuQuick.Index = 4
    Me.menuQuick.Shortcut = System.Windows.Forms.Shortcut.F4
    Me.menuQuick.Text = "Quick"
    '
    'CheckBoxShowSwaps
    '
    Me.CheckBoxShowSwaps.Checked = True
    Me.CheckBoxShowSwaps.CheckState = System.Windows.Forms.CheckState.Checked
    Me.CheckBoxShowSwaps.Location = New System.Drawing.Point(592, 416)
    Me.CheckBoxShowSwaps.Name = "CheckBoxShowSwaps"
    Me.CheckBoxShowSwaps.TabIndex = 1
    Me.CheckBoxShowSwaps.Text = "Show Swaps"
    '
    'MainMenu1
    '
    Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem1, Me.MenuItem3})
    '
    'Form1
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(6, 15)
    Me.ClientSize = New System.Drawing.Size(712, 536)
    Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.CheckBoxShowSwaps, Me.CheckBoxAscending})
    Me.Menu = Me.MainMenu1
    Me.Name = "Form1"
    Me.Text = "Sort Demos"
    Me.ResumeLayout(False)

  End Sub

#End Region

  Private Rectangles(300) As Rectangle
  Private FSortOrder As Boolean
  Private CompareProcs() As Compare = _
    {AddressOf Less, AddressOf Greater}
  Delegate Function Compare(ByVal Height1 As Integer, _
    ByVal Height2 As Integer) As Boolean

  Private Function GetCompareProc(ByVal Value _
    As Boolean) As Compare
    Return CompareProcs(Math.Abs(CInt(Value)))
  End Function

  Private Sub DrawRandomBars()

    Array.Clear(Rectangles, 0, _
      Rectangles.GetUpperBound(0))

    Dim I As Integer

    For I = Rectangles.GetLowerBound(0) To _
     Rectangles.GetUpperBound(0)
      Rectangles(I) = New Rectangle(I * 2, 0, 1, Rnd() * 200)
    Next

    Invalidate()
  End Sub

  Private Sub ConditionalInvalidate()
    If (Not CheckBoxShowSwaps.Checked) Then _
      Invalidate()
  End Sub

  Private Sub DrawRectangle(ByVal Rect As Rectangle, _
    ByVal APen As Pen)
    CreateGraphics.DrawRectangle(APen, Rect)
  End Sub

  Private Sub Form1_Paint(ByVal sender As System.Object, _
    ByVal e As System.Windows.Forms.PaintEventArgs) _
    Handles MyBase.Paint

    Dim Graphics As System.Drawing.Graphics = CreateGraphics()
    Graphics.DrawRectangles(Pens.Green, Rectangles)

  End Sub

  Public Function Greater(ByVal H1 As Integer, _
    ByVal H2 As Integer) As Boolean

    Return H1 > H2

  End Function

  Public Function Less(ByVal H1 As Integer, _
    ByVal H2 As Integer) As Boolean

    Return H1 < H2

  End Function

  Public Sub EraseOld(ByVal Rects() As Rectangle, _
    ByVal I As Integer, ByVal J As Integer)

    If (Not CheckBoxShowSwaps.Checked) Then Exit Sub
    DrawRectangle(Rects(I), Pens.LightGray)
    DrawRectangle(Rects(J), Pens.LightGray)

  End Sub

  Public Sub DrawNew(ByVal Rects() As Rectangle, _
    ByVal I As Integer, ByVal J As Integer)

    If (Not CheckBoxShowSwaps.Checked) Then Exit Sub
    DrawRectangle(Rects(I), Pens.Green)
    DrawRectangle(Rects(J), Pens.Green)

  End Sub

  Public Sub Swap(ByVal Rects() As Rectangle, _
    ByVal I As Integer, ByVal J As Integer)

    EraseOld(Rects, I, J)

    Dim R As Rectangle
    R = Rects(I)
    Rects(I) = Rects(J)
    Rects(J) = R

    Dim X As Integer = Rects(I).X
    Rects(I).X = Rects(J).X
    Rects(J).X = X

    DrawNew(Rects, I, J)
  End Sub

  Public Sub BubbleSort(ByVal Rects() As Rectangle, _
    ByVal CompareProc As Compare)

    Dim I, J As Integer
    For I = 0 To Rects.GetUpperBound(0) - 1

      For J = I + 1 To Rects.GetUpperBound(0)
        Application.DoEvents()

        If (CompareProc(Rects(I).Height, _
         Rects(J).Height)) Then

          Swap(Rects, I, J)

        End If
      Next
    Next

  End Sub

  Public Sub SelectionSort(ByVal Rects() As Rectangle, _
    ByVal CompareProc As Compare)

    Dim I, J, SwapIndex As Integer

    For I = 0 To Rects.GetUpperBound(0) - 1
      SwapIndex = I

      For J = I + 1 To Rects.GetUpperBound(0)
        If (CompareProc(Rects(SwapIndex).Height, _
          Rects(J).Height)) Then

          SwapIndex = J

        End If
      Next

      Swap(Rects, I, SwapIndex)
    Next

  End Sub

  Public Sub QuickSort(ByVal Rects() As Rectangle, _
    ByVal Left As Integer, ByVal Right As Integer, _
    ByVal Comp1 As Compare, ByVal Comp2 As Compare)

    Dim I, J As Integer
    Dim Rect As Rectangle

    If (Right > Left) Then
      Rect = Rects(Right)
      I = Left - 1
      J = Right

      Do While (True)
        Do
          I += 1
        Loop While (Comp1(Rects(I).Height, Rect.Height))

        Do
          J = J - 1
          If (J < Rects.GetLowerBound(0)) Then Exit Do
        Loop While (Comp2(Rects(J).Height, Rect.Height))

        If (I >= J) Then Exit Do

        Swap(Rects, I, J)
      Loop

      Swap(Rects, I, Right)
      QuickSort(Rects, Left, I - 1, Comp1, Comp2)
      QuickSort(Rects, I + 1, Right, Comp1, Comp2)


    End If

  End Sub

  Private Sub Form1_Load(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MyBase.Load

    DrawRandomBars()

  End Sub

  Private Sub MenuExit_Click(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MenuExit.Click

    End

  End Sub

  Private Sub MenuRandomize_Click(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MenuRandomize.Click

    DrawRandomBars()

  End Sub

  Private Sub MenuSelection_Click(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MenuSelection.Click

    SelectionSort(Rectangles, _
      GetCompareProc(CheckBoxAscending.Checked))

    ConditionalInvalidate()
  End Sub

  Private Sub MenuBubble_Click(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MenuBubble.Click

    BubbleSort(Rectangles, _
      GetCompareProc(CheckBoxAscending.Checked))

    ConditionalInvalidate()
  End Sub

  Private Sub menuQuick_Click(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles menuQuick.Click

    QuickSort(Rectangles, Rectangles.GetLowerBound(0), _
      Rectangles.GetUpperBound(0), _
      GetCompareProc(Not CheckBoxAscending.Checked), _
      GetCompareProc(CheckBoxAscending.Checked))

    ConditionalInvalidate()
  End Sub

End Class
